Scriptname _slsubmitdaintegration extends daymoyl_QuestTemplate  

_SLSubmitConfig Property _SLConfig Auto
_SLSubmitFunctions Property _SLFunctions Auto
_SLSubmitQuest Property _SLQuest Auto
_SLSubmitScene Property _SLScene Auto

Actor Property PlayerRef Auto

GlobalVariable Property _SLSubmitSurrenderGlobal Auto

Race Property Werewolf Auto
Race Property VampireLord Auto

Bool InBlackBook
Actor[] activeActors

Bool Function QuestCondition(Location akLocation, Actor akAggressor, Actor akFollower)
{Condition that must be satisfied for the quest to fire. Should be overloaded in the childs}
	If (_SLQuest.Dawnguard)
		VampireLord = Game.GetFormFromFile(0x283A, "Dawnguard.esm") as Race
	EndIf
	
	If (_SLQuest.Dragonborn)
		_SLFunctions.InitializeBlackBooks()
		InBlackBook = _SLFunctions.IsInBook()
	Else
		InBlackBook = False
	EndIf
	
	If !InBlackBook && _SLConfig.modActive && PlayerRef.GetRace() != Werewolf && PlayerRef.GetRace() != VampireLord
		Return True
	EndIf
	
	Return False
EndFunction

Bool Function QuestStart(Location CurrentLocation, Actor akAggressor, Actor akFollower)
{Starts the quest and returns true on success. Must call Start() explicitly in the parent if overloaded.}
	If !_SLQuest.IsValidTarget(akAggressor)
		Return False
	EndIf
	
	SendModEvent("da_StartRecoverSequence")
	
	activeActors = new Actor[3]
	activeActors[0] = PlayerRef
	activeActors[1] = akAggressor
	activeActors[2] = None
	
	_SLSubmitSurrenderGlobal.SetValue(2)
	
	RegisterForSingleUpdate(0.1)
	
	Return True
EndFunction

Function QuestReset()
{If some items are removed from the player, overload this function to return them to the player when the cheat option is selected in the menu.}
EndFunction

Event OnUpdate()
	_SLScene.PlayerSex(activeActors)
	;_SLFunctions.AutoSurrender()
EndEvent

